#include "serial_ctrl.h"

SDL_TimerID timer;
char param_bidon = 0;   //useless parameter to try the SDL_AddTimer fonction
HANDLE fd;              //Hadle to open RS232
char theResult[7];
char theString[7];
int result;             //if != 0 then data on RS232 OK

SDL_Thread *rThread = NULL;
SDL_mutex *theResultLock = NULL;

/* ----------------------------------
|               RS232               |
------------------------------------*/
int init_RS232(void)
{
    //------ bouton STOP
    SDL_Surface *I_STOP = SDL_LoadBMP("STOP.bmp");
    SDL_Rect P_STOP;
    P_STOP.x = 800;
    P_STOP.y = 0;
    //------ text : init
    TTF_Font *P_palisade_init = NULL;
    P_palisade_init = TTF_OpenFont("palisade.ttf", 40);
    SDL_Color couleur_rouge = {255, 0, 0};
    SDL_Surface *texte_init = TTF_RenderText_Blended(P_palisade_init, "Initialization. Plug and switch on FPGA", couleur_rouge);
    SDL_Rect P_texte_init;
    P_texte_init.x = 10;
    P_texte_init.y = 30;
    SDL_BlitSurface(texte_init, NULL, SDL_GetVideoSurface(), &P_texte_init);
    SDL_BlitSurface(I_STOP, NULL, SDL_GetVideoSurface(), &P_STOP);
    SDL_Flip(SDL_GetVideoSurface());
    //search for the right COM port
    char string[15];
    int i;
    Sleep(600);
    fd = NULL;
    while(fd == NULL)
    {
        for(i=0; i<15; i++)
        {
            sprintf(string, "\\\\.\\COM%d", i);
            fd = OpenCom(string, 9600, 8, 1);
            if(fd != NULL)
            {
                theResultLock = SDL_CreateMutex();
                char *tnames[1] = {"Thread1"};
                rThread = SDL_CreateThread(constantRead, tnames[0]);
                break;
            }
            SDL_Event event;
            while (SDL_PollEvent(&event))
            {
                if(event.type == SDL_MOUSEBUTTONUP)
                {
                    if(event.button.x>800 && event.button.x<996 && event.button.y>0 && event.button.y<105)
                    {
                        return 1;
                    }
                }
            }
        }
    }
    return 0;
}

int constantRead(void* data)
{
    char buffer[6];
    while(1)
    {
        result = ReceiveCom(fd, buffer, 5);
        SDL_LockMutex(theResultLock);
        strcpy(theResult, buffer);
        SDL_UnlockMutex(theResultLock);
    }
    return 0;
}

void stop_RS232(void)
{
    CloseCom(fd);
    SDL_DestroyMutex(theResultLock);
}


/* ----------------------------------
|                Timer              |
------------------------------------*/
//init the timer that get data from RS232
void init_timer(void)
{
    //get data every 20ms (make this value similar in VHDL)
    timer = SDL_AddTimer(20, get_RS232, &param_bidon);
}

Uint32 get_RS232(Uint32 interval, void *param)
{
    char buffer[6];
    int i;
    SDL_LockMutex(theResultLock);
    strcpy(buffer, theResult);
    SDL_UnlockMutex(theResultLock);

    for(i=0; i<5; i++)
    {
        if(buffer[i]=='A' && buffer[(i+1)%5]=='d')
        {
            theString[0]=buffer[i];
            theString[1]=buffer[(i+1)%5];
            theString[2]=buffer[(i+2)%5];
            theString[3]=buffer[(i+3)%5];
            theString[4]=buffer[(i+4)%5];
            theString[5]='\0';
            break;
        }
    }



    SDL_Event event;
    SDL_UserEvent userevent;

    // We push a new event SDL_USEREVENT in the stack
    userevent.type = SDL_USEREVENT;
    userevent.code = 0;
    userevent.data1 = NULL;
    userevent.data2 = NULL;

    event.type = SDL_USEREVENT;
    event.user = userevent;

    SDL_PushEvent(&event);

    // Please call me back in interval
    return(interval);
}

void stop_timer(void)
{
    SDL_RemoveTimer(timer);
}

/* ----------------------------------
|         Get accelerations         |
------------------------------------*/

char* get_theString(void)
{
    return theString;
}
