#include "win_serial.h"

HANDLE OpenCom(char *port,int speed,int size,int stopBits)
{
  DCB g_DCB;
  HANDLE fd;

  fd = CreateFile(port, GENERIC_READ | GENERIC_WRITE,0,NULL,OPEN_EXISTING,FILE_FLAG_WRITE_THROUGH | FILE_FLAG_NO_BUFFERING,NULL);

  if(fd == INVALID_HANDLE_VALUE)
  {
    return NULL;
  }
  else
  {
    PurgeComm(fd, PURGE_TXABORT|PURGE_RXABORT|PURGE_TXCLEAR|PURGE_RXCLEAR);

    g_DCB.DCBlength = sizeof(DCB);

    GetCommState(fd, &g_DCB);

    g_DCB.BaudRate = speed;
    g_DCB.ByteSize = size;

    g_DCB.fDtrControl = DTR_CONTROL_DISABLE; // (DISABLE)

    /*if (strcmp(Parite,"Aucune")==0)
    g_DCB.Parity = NOPARITY;
    if (strcmp(Parite,"Paire")==0)
    g_DCB.Parity = EVENPARITY;
    if (strcmp(Parite,"Impaire")==0)
    g_DCB.Parity = ODDPARITY;*/
    g_DCB.Parity = NOPARITY;

    // Gestion du Stop Bit
    if ( stopBits == 1 )
    g_DCB.StopBits = ONESTOPBIT;
    else if ( stopBits == 2 )
    g_DCB.StopBits = TWOSTOPBITS;

    SetCommState(fd, &g_DCB);

    return fd;
  }
}

int SendCom(HANDLE fd, char* data)
{
  DWORD NumBytes = 0;

  if(fd != NULL)
    if (WriteFile(fd, data, strlen(data),&NumBytes,NULL) != 0)
      return NumBytes;

  return 0;
}


int ReceiveCom(HANDLE fd, char *data, int size)
{
	COMSTAT Stat;
	DWORD Errors;
	int avBytes = 0;
	long unsigned int readBytes = 0;

	if(fd != NULL)
	{
		//Pour viter de grer un time out
		Sleep(1);
		//Pour connaitre le nombre d'octets dans le buffer d'entre
		ClearCommError(fd,&Errors,&Stat);
		avBytes = Stat.cbInQue;

		//On effectue la lecture si il y a des caractres prsents
		if(avBytes > size)
		{
			//Reception de la Chaine
			if(ReadFile(fd, data, size, &readBytes, NULL) == 0)
				return 0;
		}
		//Finition de la Chaine
		data[readBytes] = '\0' ;
		return readBytes;
	}
	else
		return 0;

}

int CloseCom(HANDLE fd)
{
  if(fd != NULL)
  {
    CloseHandle(fd);
    return 1;
  }
  return 0;
}
