#ifdef __cplusplus
    #include <cstdlib>
#else
    #include <stdlib.h>
#endif
#ifdef __APPLE__
#include <SDL/SDL.h>
#else
#include <SDL.h>
#endif

#include <SDL_ttf.h>
#include <windows.h>
#include "define.h"
#include "serial_ctrl.h"
#include "win_serial.h"
#include "videoInput.h"
#include "SDL_rotozoom.h"

int main ( int argc, char** argv )
{
    /* ----------------------------------
    |              init Video           |
    ------------------------------------*/

    //init SDL_tff
    if(TTF_Init() == -1)
    {
        fprintf(stderr, "Erreur d'initialisation de TTF_Init : %s\n", TTF_GetError());
        exit(EXIT_FAILURE);
    }

    // initialize SDL video
    if ( SDL_Init( SDL_INIT_VIDEO | SDL_INIT_TIMER) < 0 )
    {
        printf( "Unable to init SDL: %s\n", SDL_GetError() );
        return 1;
    }

    // make sure SDL cleans up before exit
    atexit(SDL_Quit);

    // create a new window
    const SDL_VideoInfo* screen_info = SDL_GetVideoInfo();
    int screen_h = screen_info->current_h;
    int screen_w = screen_info->current_w;
    SDL_Surface *screen = SDL_SetVideoMode(screen_w, screen_h, 16,
                               SDL_HWSURFACE|SDL_DOUBLEBUF|SDL_FULLSCREEN);

    if ( !screen )
    {
        printf("Unable to set video: %s\n", SDL_GetError());
        return 1;
    }

    /* ----------------------------------
    |           others inits            |
    ------------------------------------*/

    int sensitivity = 8;             //coefficient used for the motion process
    float speed = 0.50;
    bool isCursorPressed = false;   //true when user clic the sensitivity cursor and start moving it
    bool isCursor2Pressed = false;  //true when user clic the speed cursor and start moving it
    bool done = false;              //while done=false, the main loop is running
    bool isLeftHand = false;
    char theStringCpy[6];
    char infoString[40];
    int calibration_x = 0;
    int calibration_y = 0;
    int calibration_z = 0;
    int last_acc_x[4];
    int last_acc_y[4];
    int last_acc_z[4];
    int acc_x;
    int acc_y;
    int acc_z;
    //-----
    if(init_RS232()==1)         //if RS232 can't init then quit immediately : go to define.h to use prog mode
    {
        #ifndef PROG_MODE
        done = true;
        #endif
    }
    init_timer();

    /* ----------------------------------
    |       init graphic objects        |
    ------------------------------------*/
    bool M_visible = false;
        //------ background image
    SDL_Surface *I_background = NULL;
    SDL_Rect P_background;
    P_background.x = 0;
    P_background.y = 0;
        //------ text : Menu
    TTF_Font *P_palisade = NULL;
    P_palisade = TTF_OpenFont("palisade.ttf", 25);
    SDL_Color couleur_bleu = {51, 153, 255};
    SDL_Surface *texte = TTF_RenderText_Blended(P_palisade, "Menu", couleur_bleu);
    SDL_Rect P_texte;
    P_texte.x = R_P_texte_x;
    P_texte.y = R_P_texte_y;
        //------ headband
    SDL_Surface *I_menu = SDL_LoadBMP("menu.bmp");
    SDL_Rect P_menu;
    P_menu.x = R_P_menu_x;
    P_menu.y = R_P_menu_y;
        //------ bouton quit
    SDL_Surface *I_quit = SDL_LoadBMP("quit.bmp");
    SDL_SetColorKey(I_quit, SDL_SRCCOLORKEY, SDL_MapRGB(I_quit->format, 255, 255, 255));
    SDL_Rect P_quit;
    P_quit.x = R_P_quit_x;
    P_quit.y = R_P_quit_y;
        //------ left hand
    SDL_Surface *I_LHand = SDL_LoadBMP("mainG.bmp");
    SDL_SetColorKey(I_LHand, SDL_SRCCOLORKEY, SDL_MapRGB(I_LHand->format, 255, 0, 0));
    SDL_Rect P_LHand;
    P_LHand.x = R_P_LHand_x;
    P_LHand.y = R_P_LHand_y;
        //------ left hand buttons
    SDL_Surface *I_LHand_off = SDL_LoadBMP("mainG_min_off.bmp");
    SDL_Surface *I_LHand_on = SDL_LoadBMP("mainG_min_on.bmp");
    SDL_Rect P_LHand_min;
    P_LHand_min.x = R_P_LHand_min_x;
    P_LHand_min.y = R_P_LHand_min_y;
        //------ right hand
    SDL_Surface *I_RHand = SDL_LoadBMP("mainD.bmp");
    SDL_SetColorKey(I_RHand, SDL_SRCCOLORKEY, SDL_MapRGB(I_RHand->format, 255, 0, 0));
    SDL_Rect P_RHand;
    P_RHand.x = R_P_RHand_x;
    P_RHand.y = R_P_RHand_y;
        //------ right hand buttons
    SDL_Surface *I_RHand_off = SDL_LoadBMP("mainD_min_off.bmp");
    SDL_Surface *I_RHand_on = SDL_LoadBMP("mainD_min_on.bmp");
    SDL_Rect P_RHand_min;
    P_RHand_min.x = R_P_RHand_min_x;
    P_RHand_min.y = R_P_RHand_min_y;
        //------ set hand to origine button
    SDL_Surface *I_set0 = SDL_LoadBMP("set_to_0.bmp");
    SDL_SetColorKey(I_set0, SDL_SRCCOLORKEY, SDL_MapRGB(I_set0->format, 0, 0, 0));
    SDL_Rect P_set0;
    P_set0.x = R_P_set0_x;
    P_set0.y = R_P_set0_y;
        //------ blue bar selector for sensitivity
    SDL_Surface *I_selector = SDL_LoadBMP("barre_sensitivity.bmp");
    SDL_SetColorKey(I_selector, SDL_SRCCOLORKEY, SDL_MapRGB(I_selector->format, 255, 255, 255));
    SDL_Rect P_selector;
    P_selector.x = R_P_selector_x;
    P_selector.y = R_P_selector_y;
        //------ red cursor for sensitivity
    SDL_Surface *I_cursor = SDL_LoadBMP("selecteur.bmp");
    SDL_SetColorKey(I_cursor, SDL_SRCCOLORKEY, SDL_MapRGB(I_cursor->format, 255, 255, 255));
    SDL_Rect P_cursor;
    P_cursor.x = R_P_cursor_x;
    P_cursor.y = R_P_cursor_y;
        //------ sensitivity value
    TTF_Font *P_palisade3 = NULL;
    P_palisade3 = TTF_OpenFont("palisade.ttf", 24);
    SDL_Surface *T_sensitivity = TTF_RenderText_Blended(P_palisade3, "8", couleur_bleu);
    SDL_Rect P_T_sensitivity;
    P_T_sensitivity.x = R_P_T_sensitivity_x;
    P_T_sensitivity.y = R_P_T_sensitivity_y;
        //------ blue bar selector for speed
    SDL_Surface *I_selector2 = SDL_LoadBMP("barre_speed.bmp");
    SDL_SetColorKey(I_selector2, SDL_SRCCOLORKEY, SDL_MapRGB(I_selector2->format, 255, 255, 255));
    SDL_Rect P_selector2;
    P_selector2.x = R_P_selector2_x;
    P_selector2.y = R_P_selector2_y;
        //------ red cursor for speed
    SDL_Surface *I_cursor2 = SDL_LoadBMP("selecteur.bmp");
    SDL_SetColorKey(I_cursor2, SDL_SRCCOLORKEY, SDL_MapRGB(I_cursor2->format, 255, 255, 255));
    SDL_Rect P_cursor2;
    P_cursor2.x = R_P_cursor2_x;
    P_cursor2.y = R_P_cursor2_y;
        //------ speed value
    SDL_Surface *T_speed = TTF_RenderText_Blended(P_palisade3, "0.50", couleur_bleu);
    SDL_Rect P_T_speed;
    P_T_speed.x = R_P_T_speed_x;
    P_T_speed.y = R_P_T_speed_y;
        //------ CAM1 buttons
    SDL_Surface *I_CAM1 = NULL;
    SDL_Rect P_CAM1;
    P_CAM1.x = R_P_CAM1_x;
    P_CAM1.y = R_P_CAM1_y;
        //------ CAM2 buttons
    SDL_Surface *I_CAM2 = NULL;
    SDL_Rect P_CAM2;
    P_CAM2.x = R_P_CAM2_x;
    P_CAM2.y = R_P_CAM2_y;
        //------ black screen button
    SDL_Surface *I_blackScreen = SDL_LoadBMP("black_screen.bmp");
    SDL_SetColorKey(I_blackScreen, SDL_SRCCOLORKEY, SDL_MapRGB(I_blackScreen->format, 255, 255, 0));
    SDL_Rect P_blackScreen;
    P_blackScreen.x = R_P_blackScreen_x;
    P_blackScreen.y = R_P_blackScreen_y;
            //------ text : x y z
    TTF_Font *P_palisade2 = NULL;
    P_palisade2 = TTF_OpenFont("palisade.ttf", 30);
    SDL_Color couleur_vert = {0, 100, 0};
    SDL_Surface *T_xyz = TTF_RenderText_Blended(P_palisade2, "x", couleur_vert);
    SDL_Rect P_T_xyz;
    P_T_xyz.x = R_P_T_xyz_x;
    P_T_xyz.y = R_P_T_xyz_y;

    /* ----------------------------------
    |          init VideoInput          |
    ------------------------------------*/
	videoInput VI;
	switch (VI.listDevices())
	{
	    case 0:
	    I_CAM1 = SDL_LoadBMP("CAM1_off.bmp");
	    I_CAM2 = SDL_LoadBMP("CAM2_off.bmp");
	    break;

	    case 1:
	    I_CAM1 = SDL_LoadBMP("CAM1_on.bmp");
	    I_CAM2 = SDL_LoadBMP("CAM2_off.bmp");
	    break;

	    default:
	    I_CAM1 = SDL_LoadBMP("CAM1_on.bmp");
	    I_CAM2 = SDL_LoadBMP("CAM2_on.bmp");
	}
	SDL_SetColorKey(I_CAM1, SDL_SRCCOLORKEY, SDL_MapRGB(I_CAM1->format, 255, 255, 0));
	SDL_SetColorKey(I_CAM2, SDL_SRCCOLORKEY, SDL_MapRGB(I_CAM2->format, 255, 255, 0));

    /* ----------------------------------
    |         program main loop         |
    ------------------------------------*/
    while (!done)
    {
        // message processing loop
        SDL_Event event;
        while (SDL_PollEvent(&event))
        {
            // check for messages
            switch (event.type)
            {
                // exit if the window is closed
            case SDL_QUIT:
                done = true;
                break;

                // check for keypresses
            case SDL_KEYDOWN:
                {
                    // exit if ESCAPE is pressed
                    if (event.key.keysym.sym == SDLK_ESCAPE)
                        done = true;
                    break;
                }
            case SDL_MOUSEMOTION:
                {
                    if(event.motion.y > 120 && (isCursorPressed==false))
                    {
                        M_visible = false;
                    }
                    else
                    {
                        if(event.motion.y==0)
                        {
                            M_visible = true;
                        }
                    }
                    if(isCursorPressed)
                    {
                        if(event.motion.x<R_P_selector_x+26)
                        {
                            P_cursor.x = R_P_selector_x+10;
                        }
                        else
                        {
                            if(event.motion.x>R_P_selector_x+477)
                            {
                                P_cursor.x = R_P_selector_x+460;
                            }
                            else
                            {
                                P_cursor.x = event.motion.x-16;
                                sensitivity = (int)((event.motion.x - (R_P_selector_x + 26))/23);   //we make the sensitivity value between 0 and 20
                            }
                        }
                        char value[3];
                        sprintf(value, "%d", sensitivity);
                        T_sensitivity = TTF_RenderText_Blended(P_palisade3, value, couleur_bleu);
                    }

                    if(isCursor2Pressed)
                    {
                        if(event.motion.x<R_P_selector2_x+26)
                        {
                            P_cursor2.x = R_P_selector2_x+10;
                        }
                        else
                        {
                            if(event.motion.x>R_P_selector2_x+477)
                            {
                                P_cursor2.x = R_P_selector2_x+460;
                            }
                            else
                            {
                                P_cursor2.x = event.motion.x-16;
                                speed = (event.motion.x - (R_P_selector2_x + 26.0))/150.3;   //we make the speed value between 0 and 3
                            }
                        }
                        char value[5];
                        sprintf(value, "%.2f", speed);
                        T_speed = TTF_RenderText_Blended(P_palisade3, value, couleur_bleu);
                    }

                    break;
                }
            case SDL_MOUSEBUTTONUP:
                {
                    if(event.button.x>R_P_quit_x && event.button.x<R_P_quit_x+77 && event.button.y>R_P_quit_y &&    //quit
                        event.button.y<R_P_quit_y+44 && M_visible)
                    {
                       done = true;
                    }
                    else
                    {
                        if(event.button.x>R_P_LHand_min_x && event.button.x<R_P_LHand_min_x+140 && event.button.y>R_P_LHand_min_y &&  //activate left hand
                            event.button.y<R_P_LHand_min_y+80 && M_visible)
                        {
                            isLeftHand = true;
                        }
                        else
                        {
                            if(event.button.x>R_P_RHand_min_x && event.button.x<R_P_RHand_min_x+140 && event.button.y>R_P_RHand_min_y &&  //activate right hand
                            event.button.y<R_P_RHand_min_y+80 && M_visible)
                            {
                                isLeftHand = false;
                            }
                            else
                            {
                                if(event.button.x>R_P_set0_x && event.button.x<R_P_set0_x+99 &&      //move hand to origine
                                   event.button.y>R_P_set0_y && event.button.y<R_P_set0_y+89 && M_visible)
                                {
                                    P_LHand.x = R_P_LHand_x;
                                    P_LHand.y = R_P_LHand_y;
                                    P_RHand.x = R_P_RHand_x;
                                    P_RHand.y = R_P_RHand_y;
                                    calibration_x = theStringCpy[2];
                                    calibration_y = theStringCpy[3];
                                    calibration_z = theStringCpy[4];
                                }
                                else
                                {
                                    if(event.button.x>R_P_CAM1_x && event.button.x<R_P_CAM1_x+68 && event.button.y>R_P_CAM1_y && //take picture from CAM1
                                        event.button.y<R_P_CAM1_y+45 && VI.listDevices()>0 && M_visible)
                                    {
                                        double coef_rotozoom;  //this is the coefficient to use in the zoomSurface() function to make the picture full screen
                                        VI.setupDevice(0);
                                        VI.setupDevice(0, 640, 480);
                                        int cam0_width = VI.getWidth(0);
                                        int cam0_height = VI.getHeight(0);
                                        int cam0_size = VI.getSize(0);
                                        if ((screen_w/cam0_width) < (screen_h<cam0_height))     //find coef_rotozoom and place the picture in the center of the screen
                                        {
                                            coef_rotozoom = (double)screen_w/(double)cam0_width;
                                            P_background.y = (screen_h - (int)(coef_rotozoom*cam0_height))/2;
                                        }
                                        else
                                        {
                                            coef_rotozoom = (double)screen_h/(double)cam0_height;
                                            P_background.x = (screen_w - (coef_rotozoom*cam0_width))/2;
                                        }
                                        unsigned char* cam0_buffer = new unsigned char[cam0_size];
                                        while(!VI.isFrameNew(0));
                                            VI.getPixels(0, cam0_buffer, false, true);
                                        I_background = SDL_CreateRGBSurfaceFrom(cam0_buffer, cam0_width, cam0_height, (cam0_size/(cam0_height*cam0_width))*8, cam0_size/cam0_height, 0, 0, 0, 0);
                                        I_background = zoomSurface(I_background, coef_rotozoom, coef_rotozoom, 1);
                                        VI.stopDevice(0);
                                    }
                                    else
                                    {
                                        if(event.button.x>R_P_CAM1_x && event.button.x<R_P_CAM1_x+68 &&  event.button.y>R_P_CAM1_y+46 &&//acces settings of CAM1
                                            event.button.y<R_P_CAM1_y+92 && VI.listDevices()>0 && M_visible)
                                        {
                                            VI.setupDevice(0);
                                            VI.showSettingsWindow(0);
                                            VI.stopDevice(0);
                                        }
                                        else
                                        {
                                            if(event.button.x>R_P_CAM2_x && event.button.x<R_P_CAM2_x+68 &&  event.button.y>R_P_CAM2_y &&//take picture from CAM2
                                                event.button.y<R_P_CAM2_y+45 && VI.listDevices()>1 && M_visible)
                                            {
                                                double coef_rotozoom;  //this is the coefficient to use in the zoomSurface() function to make the picture full screen
                                                VI.setupDevice(1);
                                                VI.setupDevice(1, 640, 480);
                                                int cam1_width = VI.getWidth(1);
                                                int cam1_height = VI.getHeight(1);
                                                int cam1_size = VI.getSize(1);
                                                if ((screen_w/cam1_width) < (screen_h<cam1_height))     //find coef_rotozoom and place the picture in the center of the screen
                                                {
                                                    coef_rotozoom = (double)screen_w/(double)cam1_width;
                                                    P_background.y = (screen_h - (int)(coef_rotozoom*cam1_height))/2;
                                                }
                                                else
                                                {
                                                    coef_rotozoom = (double)screen_h/(double)cam1_height;
                                                    P_background.x = (screen_w - (coef_rotozoom*cam1_width))/2;
                                                }
                                                unsigned char* cam1_buffer = new unsigned char[cam1_size];
                                                while(!VI.isFrameNew(1));
                                                    VI.getPixels(1, cam1_buffer, false, true);
                                                I_background = SDL_CreateRGBSurfaceFrom(cam1_buffer, cam1_width, cam1_height, (cam1_size/(cam1_height*cam1_width))*8, cam1_size/cam1_height, 0, 0, 0, 0);
                                                I_background = zoomSurface(I_background, coef_rotozoom, coef_rotozoom, 1);
                                                VI.stopDevice(1);
                                            }
                                            else
                                            {
                                                if(event.button.x>R_P_CAM2_x && event.button.x<R_P_CAM2_x+68 &&  event.button.y>R_P_CAM2_y+46 &&    //acces settings of CAM2
                                                    event.button.y<R_P_CAM2_y+92 && VI.listDevices()>1 && M_visible)
                                                {
                                                    VI.setupDevice(1);
                                                    VI.showSettingsWindow(1);
                                                    VI.stopDevice(1);
                                                }
                                                else
                                                {
                                                    if(event.button.x>R_P_blackScreen_x && event.button.x<R_P_blackScreen_x+84 &&  event.button.y>R_P_blackScreen_y &&    //black screen
                                                        event.button.y<R_P_blackScreen_y+58 && M_visible)
                                                    {
                                                        unsigned char* blackscreen = new unsigned char[screen_h*screen_w];
                                                        for(int z=0; z<screen_h*screen_w; z++)
                                                        {
                                                            blackscreen[z]=0xFF;
                                                        }
                                                        I_background = SDL_CreateRGBSurfaceFrom(blackscreen, screen_w, screen_h, 1, screen_w, 0, 0, 0, 0);
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                    if(isCursorPressed)         //sensitivity
                    {
                        isCursorPressed = false;
                    }
                    if(isCursor2Pressed)        //speed
                    {
                        isCursor2Pressed = false;
                    }
                    break;
                }
            case SDL_MOUSEBUTTONDOWN:
                {
                    if(event.button.x>P_cursor.x && event.button.x<P_cursor.x+33 && event.button.y>P_cursor.y && event.button.y<P_cursor.y+39 && M_visible)
                    {
                        isCursorPressed = true;
                    }
                    if(event.button.x>P_cursor2.x && event.button.x<P_cursor2.x+33 && event.button.y>P_cursor2.y && event.button.y<P_cursor2.y+39 && M_visible)
                    {
                        isCursor2Pressed = true;
                    }
                }
            case SDL_USEREVENT:
                {
                    //future algorithms sould make a different process depending on the selected hand
                //    if(isLeftHand)
                //    {
                        strcpy(theStringCpy, get_theString());
                        acc_x = theStringCpy[2];
                        acc_y = theStringCpy[3];
                        acc_z = theStringCpy[4];

                        //acc_y = acc_y - calibration_y;
                        if (abs(acc_y - calibration_y) > sensitivity)
                            acc_y = acc_y - calibration_y;
                        else
                            acc_y = 0;

                        if(P_LHand.x <= 0)
                        {
                            if (((last_acc_y[3]+2*last_acc_y[1]+acc_y)/4) > 0)
                            {
                                P_LHand.x = P_LHand.x + (last_acc_y[3]+2*last_acc_y[1]+acc_y)*speed;
                            }
                        }
                        else
                        {
                            if (P_LHand.x>=940)
                            {
                                if (((last_acc_y[3]+2*last_acc_y[1]+acc_y)/4) < 0)
                                {
                                    P_LHand.x = P_LHand.x + (last_acc_y[3]+2*last_acc_y[1]+acc_y)*speed;
                                }
                            }
                            else
                            {
                                P_LHand.x = P_LHand.x + (last_acc_y[3]+2*last_acc_y[1]+acc_y)*speed;
                            }
                        }

                        last_acc_y[3] = last_acc_y[2];
                        last_acc_y[2] = last_acc_y[1];
                        last_acc_y[1] = last_acc_y[0];
                        last_acc_y[0] = acc_y;
                //    }
                //    else
                //    {

                //    }
                }

            } // end switch
        } // end of message processing


        // ---------- CLEAR SCREEN --------- //
        SDL_FillRect(screen, 0, SDL_MapRGB(screen->format, 0, 0, 0));

        // ---- AND DRAW A FRESH SCREEN ---- //
        SDL_BlitSurface(I_background, NULL, screen, &P_background);
        if(isLeftHand)
        {
            SDL_BlitSurface(I_LHand, NULL, screen, &P_LHand);
        }
        else
        {
            SDL_BlitSurface(I_RHand, NULL, screen, &P_RHand);
        }
        if(M_visible)
        {
            SDL_BlitSurface(I_menu, NULL, screen, &P_menu);
            SDL_BlitSurface(texte, NULL, screen, &P_texte); /* Blit du texte */
            SDL_BlitSurface(I_quit, NULL, screen, &P_quit);
            SDL_BlitSurface(I_set0, NULL, screen, &P_set0);
            SDL_BlitSurface(I_selector, NULL, screen, &P_selector);
            SDL_BlitSurface(I_cursor, NULL, screen, &P_cursor);
            SDL_BlitSurface(T_sensitivity, NULL, screen, &P_T_sensitivity);
            SDL_BlitSurface(I_selector2, NULL, screen, &P_selector2);
            SDL_BlitSurface(I_cursor2, NULL, screen, &P_cursor2);
            SDL_BlitSurface(T_speed, NULL, screen, &P_T_speed);
            SDL_BlitSurface(I_CAM1, NULL, screen, &P_CAM1);
            SDL_BlitSurface(I_CAM2, NULL, screen, &P_CAM2);
            SDL_BlitSurface(I_blackScreen, NULL, screen, &P_blackScreen);
            if(isLeftHand)
            {
                SDL_BlitSurface(I_LHand_on, NULL, screen, &P_LHand_min);
                SDL_BlitSurface(I_RHand_off, NULL, screen, &P_RHand_min);
            }
            else
            {
                SDL_BlitSurface(I_LHand_off, NULL, screen, &P_LHand_min);
                SDL_BlitSurface(I_RHand_on, NULL, screen, &P_RHand_min);
            }
        }
        else
        {
            sprintf(infoString, " x:%d     y:%d     z:%d     %s", acc_x, acc_y, acc_z, theStringCpy);
            T_xyz = TTF_RenderText_Blended(P_palisade2, infoString, couleur_vert);
            SDL_BlitSurface(T_xyz, NULL, screen, &P_T_xyz);
        }

        // DRAWING ENDS HERE

        // finally, update the screen :)
        SDL_Flip(screen);
    } // --- END MAIN LOOP ---

    //everyone is now free !
    SDL_FreeSurface(I_menu);   /* On libre la surface */
    SDL_FreeSurface(I_quit);
    SDL_FreeSurface(I_LHand);
    SDL_FreeSurface(I_LHand_off);
    SDL_FreeSurface(I_LHand_on);
    SDL_FreeSurface(I_RHand);
    SDL_FreeSurface(I_RHand_off);
    SDL_FreeSurface(I_RHand_on);
    SDL_FreeSurface(I_set0);
    TTF_CloseFont(P_palisade);
    TTF_Quit();
    stop_timer();
    stop_RS232();

    // all is well ;)
    printf("Exited cleanly\n");
    return 0;
}
